extern float4x4	g_Projection :	register(c0);
extern float4	g_Dimensions :	register(c4);



struct VS_OUTPUT
{
	float4	m_Position :	POSITION;
	float4	m_Colour :		COLOR0;
	float	m_PointSize :	PSIZE;
	float2	m_TexCoord :	TEXCOORD0;
};



struct VS_INPUT
{
	float4	m_Position :	POSITION;
	float4	m_Colour :		COLOR0;
	float	m_PointSize :	PSIZE;
};




/*
 * Particles vertex shader
 */
VS_OUTPUT MainVS(VS_INPUT input)
{
 	VS_OUTPUT output	=	(VS_OUTPUT) 0;

	output.m_Position	=	mul(input.m_Position, g_Projection);
	output.m_PointSize	=	input.m_PointSize * g_Dimensions.y / output.m_Position.w;
	output.m_Colour		=	input.m_Colour;

	return output;
}